-- ui screen events

function OnLoad ()
	SetProperty ("/:enter_trans_duration", 0.5);
	SetProperty ("/:leave_trans_duration", 0.3);
	CacheSound ("music/levelcomplete.ogg");
end;


level_reached = 0;
percent_reached = 0;
timer = -0.4;
percentvalue = 0;

function Reset ()
	timer = 0;
	phase = 0;
end;


function UpdateTalismanDesc ()

	index = Azkend_GetSlotPowerup (0);
	name = Azkend_GetPowerupName (index);
	desc = Azkend_GetPowerupDesc (index);
	if(name == "!NONE") then
		return;
	end;
	SetProperty ("name:label.text", name);
	--SetProperty ("desc:label.text", desc);
	SetProperty ("big_talisman_bm:label.bitmap", Azkend_GetPowerupBitmapBig (index));
end;


function OnEnter ()
	Reset ();
	UpdateTalismanDesc ();
	StopMusic (2);
	PlaySound ("music/levelcomplete.ogg");
	SaveTotalScore ();
	level_reached = clamp (Azkend_GetSurvivalLevelReached (), 0, 10);
	
	--level_reached = 10;
	
	percent_reached = Azkend_GetSurvivalLevelReached ();
	
	SetProperty ("percent:label.text", "0%");

	
	--percent_reached = 14;
	percentvalue = 0;
	Print("You reached " .. percent_reached .. "\n");
end;

function OnLeave ()
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
		DeleteGameState ();
		SwitchScreen ("SurvivalMode");
		return;
	end;
	if (name == "Reset") then
		Reset ();
		return;
	end;
	
end;

function spawnAppearFx(name)
	x = GetProperty(name..":static_position.x");
	y = GetProperty(name..":static_position.y");
	height = GetProperty(name..":height");
	SpawnFX ("fxs/bigstar.lua", x, y+(height/2), 180, 0);		
end;

function OnUpdate (tdelta)

	timer = timer + tdelta;
	if (timer > 0 and phase < 2*(timer-0.3-0.15)/0.3 and phase < level_reached) then
		phase = phase + 1;
		if(phase == 10) then
			PlaySound("music/trophy.ogg");
		end;
		
		--Print ("new phase " .. phase .. "\n");
	end;

	
	if (timer > 0 and percentvalue < 2*(timer-0.3-0.15)/0.3 and percentvalue < percent_reached) then
		percentvalue = percentvalue + 1;
		SetProperty ("percent:label.text", (percentvalue*10).."%");
		spawnAppearFx("percent");
		chan = NX_PlaySound ("sfx/awardingsound01.ogg");
		NX_SetChanFrequence (chan, 0.9 + percentvalue * 0.1);
	end;
	
	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 60);
	SetProperty ("panel:alpha", trans);
	
end;

function clamp (value, min_value, max_value)
	value = math.min (value, max_value);
	value = math.max (value, min_value);
	return value;
end;

function OnDraw ()

	i = 0;

 	alpha = GetProperty ("panel:alpha");

	while (i < 10) do

		x = GetProperty ("star_pos:static_position.x");
		y = GetProperty ("star_pos:static_position.y");
		
		x = x + i * 33;
		
		NX_SetAlpha (alpha);
		NX_DrawBitmapRS ("ui/gfx/star-off.png", x, y, 0, 1);
		
		t = clamp (2*timer - i*0.3, 0, 1);
		y = y + clamp ((1-t)*200, 0, 200);
		
		scale = 1+clamp ((1-t)*3, 0, 1);
		NX_SetAlpha (alpha*clamp (t, 0, 1));
		
		
		
		if (i < level_reached) then
			NX_DrawBitmapRS ("ui/gfx/star-on.png", x, y, 0, scale);
		end;


		i = i + 1;
	end;
end;
